/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.block.entity;

import dev.ftb.extendedexchange.EMCSyncHandler;
import dev.ftb.extendedexchange.block.entity.AbstractEMCBlockEntity;
import java.math.BigInteger;
import java.util.UUID;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AbstractLinkBlockEntity
extends AbstractEMCBlockEntity {
    private UUID ownerId = Util.f_137441_;
    private String ownerName = "";

    public AbstractLinkBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.ownerId = tag.m_128342_("Owner");
        this.ownerName = tag.m_128461_("OwnerName");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_("Owner", this.ownerId);
        tag.m_128359_("OwnerName", this.ownerName);
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("OwnerName", this.ownerName);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.ownerName = tag.m_128461_("OwnerName");
    }

    @Override
    public void tickServer() {
        ServerPlayer player;
        if (this.nonNullLevel().m_46467_() % 20L == 0L && this.storedEMC > 0L && (player = this.nonNullLevel().m_142572_().m_6846_().m_11259_(this.ownerId)) != null) {
            player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(provider -> {
                provider.setEmc(provider.getEmc().add(BigInteger.valueOf(this.storedEMC)));
                this.storedEMC = 0L;
                this.m_6596_();
                EMCSyncHandler.INSTANCE.needsSync(player);
            });
        }
    }

    @Override
    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }

    @Override
    public long getStoredEmc() {
        return this.storedEMC;
    }

    @Override
    public long getMaximumEmc() {
        return Long.MAX_VALUE;
    }

    @Override
    public long extractEmc(long emc, IEmcStorage.EmcAction action) {
        long toExtract = Math.min(this.storedEMC, emc);
        if (toExtract > 0L) {
            this.storedEMC -= toExtract;
            this.m_6596_();
        }
        return toExtract;
    }

    @Override
    public long insertEmc(long emc, IEmcStorage.EmcAction action) {
        long toInsert = Math.min(this.getMaximumEmc() - this.storedEMC, emc);
        if (toInsert > 0L && action.execute()) {
            this.storedEMC += toInsert;
            this.m_6596_();
        }
        return toInsert;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void setOwner(LivingEntity entity) {
        this.ownerId = entity.m_142081_();
        this.ownerName = entity.m_6302_();
    }

    public void trySyncEMC() {
        EMCSyncHandler.INSTANCE.needsSync(this.getOwnerId());
    }
}

